// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>

using namespace std;

const int MAX = 1010;
const int off = 2;

bool a[MAX][MAX];
vector<pair<int, int>> E[MAX][MAX];

int main(void) {
  int n;
  scanf("%d", &n);
  for (int i = 0; i < n; ++i) {
    int x, y;
    scanf("%d %d", &x, &y); 
    x += off, y += off;
    a[x][y] = true;
  }

  for (int x = 1; x < MAX-1; ++x)
    for (int y = 1; y < MAX-1; ++y) {
      if (a[x-1][y] != a[x][y]) {
        E[x][y].push_back({x, y+1});
        E[x][y+1].push_back({x, y});
      }
      if (a[x][y-1] != a[x][y]) {
        E[x][y].push_back({x+1, y});
        E[x+1][y].push_back({x, y});
      }
    }

  for (int x = 0; x < MAX; ++x)
    for (int y = 0; y < MAX; ++y)
      if (E[x][y].size()) {
        int cx = x, cy = y;
        int px = x, py = y+1;
        vector<pair<int, int>> ans;
        do {
          int nx, ny;
          tie(nx, ny) = E[cx][cy][ (E[cx][cy][0] == make_pair(px, py)) ];
          if ((nx-cx)*(cx-px) + (ny-cy)*(cy-py) == 0) ans.push_back({cx, cy});

          px = cx, py = cy;
          cx = nx, cy = ny;
        } while (cx != x || cy != y);

        printf("%d\n", (int)ans.size());
        for (auto& p: ans) printf("%d %d\n", p.first-off, p.second-off);
        return 0;
      }
  
  return 0;
}
